import scipy.stats as stats
import pandas as pd
from bioinfokit import visuz

f1,f2 = open('self_name.txt'),open('self_oil.txt')

name = [i.strip() for i in f1.readlines()]
content = [i.strip() for i in f2.readlines()]

f1.close()
f2.close()

fa_dict = {1:'C16-0',2:'C18:0',3:'C18-1',4:'C18-2',5:'C18-3',6:'C20-0',7:'C20-1',8:'ODP'}

f = open('self_p.txt','w')

f.write('name'+'\t'+'pvalue'+'\t'+'fa'+'\n')


for num in range(1,9):

	wt = []

	for i in content:
		if 'WT' in i:
			fa_percent = float(i.split('\t')[num])
			wt.append(fa_percent)


	for k in name:
		dock = []
		for j in content:
			if k in j:
				fa_percent1 = float(j.split('\t')[num])
				dock.append(fa_percent1)
		stat,p = stats.ttest_ind(wt,dock)
		f.write(k+'\t'+str(p)+'\t'+fa_dict[num]+'\n')

f.close()

df = pd.read_csv('self_p.txt',sep='\t',header=0)


visuz.marker.mhat(df=df, chr='fa', pv='pvalue',dim=(7,2.5),dotsize=5,figtype='pdf',
	figname='self',gwas_sign_line=True, gwasp=1E-02)

